/*
 * Decompiled with CFR 0.152.
 */
package com.bdj_animator.runtime;

import com.bdj_animator.runtime.FixedFrameSkipStrategy;
import com.bdj_animator.runtime.FrameSkipStrategy;
import com.bdj_animator.runtime.MeasuringFrameSkipStrategy;
import com.bdj_animator.runtime.RectangleCollector;
import com.bdj_animator.runtime.Stage;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class FrameDrawManager {
    private Stage a;
    private FrameSkipStrategy b;
    private Image c;
    private long d;
    private final RectangleCollector e;
    private boolean f;

    public FrameDrawManager(Stage stage, Image image) {
        if (stage == null) {
            throw new NullPointerException();
        }
        if (image == null) {
            throw new NullPointerException();
        }
        this.a = stage;
        this.c = image;
        this.e = new RectangleCollector();
        this.startAutoFrameSkip();
    }

    public void startAutoFrameSkip() {
        this.setFrameSkipStrategy(new MeasuringFrameSkipStrategy());
        this.f = true;
    }

    public void startFrameSkip(int n) {
        this.setFrameSkipStrategy(new FixedFrameSkipStrategy(n));
        this.f = true;
    }

    public void setFrameSkipStrategy(FrameSkipStrategy frameSkipStrategy) {
        if (frameSkipStrategy == null) {
            throw new NullPointerException();
        }
        this.b = frameSkipStrategy;
    }

    public FrameSkipStrategy getFrameSkipStrategy() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawNextFrame(Graphics graphics) {
        Object object = Stage.getSyncObject();
        synchronized (object) {
            this.b();
            this.a.nextFrame();
            if (this.f && this.b.isSkipFrame()) {
                this.b.nextFrame();
                return;
            }
            this.a(graphics);
        }
    }

    private void a(Graphics graphics) {
        Rectangle rectangle = this.a();
        if (rectangle == null) {
            this.b.nextFrame();
            return;
        }
        this.a(rectangle);
        this.a(graphics, rectangle);
        Toolkit.getDefaultToolkit().sync();
        this.b.drawn(this.c());
        this.b.nextFrame();
    }

    private Rectangle a() {
        this.e.clear();
        this.a.getRepaintRect(this.e);
        Rectangle rectangle = this.e.getRectangle();
        return rectangle;
    }

    private void a(Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)this.c.getGraphics();
        graphics2D.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.a.draw(graphics2D, rectangle, false);
    }

    private void a(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = n + rectangle.width;
        int n3 = rectangle.y;
        int n4 = n3 + rectangle.height;
        graphics.drawImage(this.c, n, n3, n2, n4, n, n3, n2, n4, null);
    }

    private void b() {
        this.d = System.currentTimeMillis();
    }

    private int c() {
        return (int)(System.currentTimeMillis() - this.d);
    }

    public void setFrameSkipEnabled(boolean bl) {
        this.f = bl;
    }

    public boolean isFrameSkipEnabled() {
        return this.f;
    }

    public int getFrameSkip() {
        return this.b.getFrameSkip();
    }
}

