/*
 * Decompiled with CFR 0.152.
 */
package com.bdj_animator.runtime;

import com.bdj_animator.runtime.MovieClip;
import com.bdj_animator.runtime.Stage;
import com.bdj_animator.runtime.Timeline;
import com.bdj_animator.runtime.util.StringUtility;
import java.util.ArrayList;
import java.util.List;

public class Scene {
    private final String a;
    private final List b;
    private final Stage c;

    public Scene(String string, Stage stage) {
        this.a = string;
        if (stage == null) {
            throw new IllegalArgumentException("Argument 'stage' can't be null");
        }
        this.c = stage;
        this.b = new ArrayList();
    }

    public String getName() {
        return this.a;
    }

    public void add(MovieClip movieClip) {
        this.b.add(movieClip);
    }

    public void activate() {
        this.c.removeAllChildren();
        this.a();
        int n = this.b.size();
        for (int i = 0; i < n; ++i) {
            MovieClip movieClip = (MovieClip)this.b.get(i);
            movieClip.setVisible(true);
            movieClip.changeCurrentTimeline(null, false);
            this.c.addChild(movieClip);
        }
    }

    public void deactivate() {
        this.b();
    }

    private void a() {
        int n = this.b.size();
        for (int i = 0; i < n; ++i) {
            MovieClip movieClip = (MovieClip)this.b.get(i);
            movieClip.loadResources();
        }
    }

    private void b() {
        int n = this.b.size();
        for (int i = 0; i < n; ++i) {
            MovieClip movieClip = (MovieClip)this.b.get(i);
            movieClip.releaseResources();
        }
    }

    public List getAllMovieClips() {
        return this.b;
    }

    public MovieClip getMovieClip(String string) {
        return this.findMovieClip(string);
    }

    public MovieClip findMovieClip(String string) {
        int n = this.b.size();
        for (int i = 0; i < n; ++i) {
            MovieClip movieClip = (MovieClip)this.b.get(i);
            if (!StringUtility.a(movieClip.getName(), string)) continue;
            return movieClip;
        }
        return null;
    }

    public MovieClip getMovieClip(Class clazz) {
        return this.findMovieClip(clazz);
    }

    public MovieClip findMovieClip(Class clazz) {
        int n = this.b.size();
        for (int i = 0; i < n; ++i) {
            MovieClip movieClip = (MovieClip)this.b.get(i);
            if (movieClip.getClass() != clazz) continue;
            return movieClip;
        }
        return null;
    }

    public void startAnimation(String string, boolean bl) {
        int n = this.b.size();
        for (int i = 0; i < n; ++i) {
            MovieClip movieClip = (MovieClip)this.b.get(i);
            Timeline timeline = movieClip.getTimeline(string);
            if (timeline == null) continue;
            movieClip.changeCurrentTimeline(timeline, bl);
        }
    }

    public Stage getStage() {
        return this.c;
    }

    public boolean isLocked() {
        int n = this.b.size();
        for (int i = 0; i < n; ++i) {
            MovieClip movieClip = (MovieClip)this.b.get(i);
            if (!movieClip.isLock()) continue;
            return true;
        }
        return false;
    }

    public List getMovieClipList() {
        return this.b;
    }
}

