/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.enum;

import io.pttt;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;

public abstract class Enum
implements Comparable,
Serializable {
    private static final long serialVersionUID = -487045951170455942L;
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    private static Map cEnumClasses = new WeakHashMap();
    private final String iName;
    private final transient int iHashCode;
    protected transient String iToString = null;
    static /* synthetic */ Class class$org$apache$commons$lang$enum$Enum;
    static /* synthetic */ Class class$org$apache$commons$lang$enum$ValuedEnum;

    protected Enum(String string) {
        this.init(string);
        this.iName = string;
        this.iHashCode = 7 + this.getEnumClass().hashCode() + 3 * string.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String string) {
        Entry entry;
        if (StringUtils.isEmpty(string)) {
            throw new IllegalArgumentException("The Enum name must not be empty or null");
        }
        Class clazz = this.getEnumClass();
        if (clazz == null) {
            throw new IllegalArgumentException("getEnumClass() must not be null");
        }
        Class clazz2 = this.getClass();
        boolean bl = false;
        while (clazz2 != null && clazz2 != (class$org$apache$commons$lang$enum$Enum == null ? Enum.class$("org.apache.commons.lang.enum.Enum") : class$org$apache$commons$lang$enum$Enum) && clazz2 != (class$org$apache$commons$lang$enum$ValuedEnum == null ? Enum.class$("org.apache.commons.lang.enum.ValuedEnum") : class$org$apache$commons$lang$enum$ValuedEnum)) {
            if (clazz2 == clazz) {
                bl = true;
                break;
            }
            clazz2 = pttt.sc(clazz2);
        }
        if (!bl) {
            throw new IllegalArgumentException("getEnumClass() must return a superclass of this class");
        }
        Class clazz3 = class$org$apache$commons$lang$enum$Enum == null ? (class$org$apache$commons$lang$enum$Enum = Enum.class$("org.apache.commons.lang.enum.Enum")) : class$org$apache$commons$lang$enum$Enum;
        synchronized (clazz3) {
            entry = (Entry)cEnumClasses.get(clazz);
            if (entry == null) {
                entry = Enum.createEntry(clazz);
                WeakHashMap<Class, Entry> weakHashMap = new WeakHashMap<Class, Entry>();
                weakHashMap.putAll(cEnumClasses);
                weakHashMap.put(clazz, entry);
                cEnumClasses = weakHashMap;
            }
        }
        if (entry.map.containsKey(string)) {
            throw new IllegalArgumentException("The Enum name must be unique, '" + string + "' has already been added");
        }
        entry.map.put(string, this);
        entry.list.add(this);
    }

    protected Object readResolve() {
        Entry entry = (Entry)cEnumClasses.get(this.getEnumClass());
        if (entry == null) {
            return null;
        }
        return entry.map.get(this.getName());
    }

    protected static Enum getEnum(Class clazz, String string) {
        Entry entry = Enum.getEntry(clazz);
        if (entry == null) {
            return null;
        }
        return (Enum)entry.map.get(string);
    }

    protected static Map getEnumMap(Class clazz) {
        Entry entry = Enum.getEntry(clazz);
        if (entry == null) {
            return EMPTY_MAP;
        }
        return entry.unmodifiableMap;
    }

    protected static List getEnumList(Class clazz) {
        Entry entry = Enum.getEntry(clazz);
        if (entry == null) {
            return Collections.EMPTY_LIST;
        }
        return entry.unmodifiableList;
    }

    protected static Iterator iterator(Class clazz) {
        return Enum.getEnumList(clazz).iterator();
    }

    private static Entry getEntry(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        if (!(class$org$apache$commons$lang$enum$Enum == null ? (class$org$apache$commons$lang$enum$Enum = Enum.class$("org.apache.commons.lang.enum.Enum")) : class$org$apache$commons$lang$enum$Enum).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("The Class must be a subclass of Enum");
        }
        Entry entry = (Entry)cEnumClasses.get(clazz);
        return entry;
    }

    private static Entry createEntry(Class clazz) {
        Entry entry = new Entry();
        Class clazz2 = pttt.sc(clazz);
        while (clazz2 != null && clazz2 != (class$org$apache$commons$lang$enum$Enum == null ? Enum.class$("org.apache.commons.lang.enum.Enum") : class$org$apache$commons$lang$enum$Enum) && clazz2 != (class$org$apache$commons$lang$enum$ValuedEnum == null ? Enum.class$("org.apache.commons.lang.enum.ValuedEnum") : class$org$apache$commons$lang$enum$ValuedEnum)) {
            Entry entry2 = (Entry)cEnumClasses.get(clazz2);
            if (entry2 != null) {
                entry.list.addAll(entry2.list);
                entry.map.putAll(entry2.map);
                break;
            }
            clazz2 = pttt.sc(clazz2);
        }
        return entry;
    }

    public final String getName() {
        return this.iName;
    }

    public Class getEnumClass() {
        return this.getClass();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() == this.getClass()) {
            return this.iName.equals(((Enum)object).iName);
        }
        if (!object.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        return this.iName.equals(this.getNameInOtherClassLoader(object));
    }

    public final int hashCode() {
        return this.iHashCode;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (object.getClass() != this.getClass()) {
            if (object.getClass().getName().equals(this.getClass().getName())) {
                return this.iName.compareTo(this.getNameInOtherClassLoader(object));
            }
            throw new ClassCastException("Different enum class '" + ClassUtils.getShortClassName(object.getClass()) + "'");
        }
        return this.iName.compareTo(((Enum)object).iName);
    }

    private String getNameInOtherClassLoader(Object object) {
        try {
            Method method = object.getClass().getMethod("getName", null);
            String string = (String)method.invoke(object, null);
            return string;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        throw new IllegalStateException("This should not happen");
    }

    public String toString() {
        if (this.iToString == null) {
            String string = ClassUtils.getShortClassName(this.getEnumClass());
            this.iToString = string + "[" + this.getName() + "]";
        }
        return this.iToString;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return pttt.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Entry {
        final Map map = new HashMap();
        final Map unmodifiableMap = Collections.unmodifiableMap(this.map);
        final List list = new ArrayList(25);
        final List unmodifiableList = Collections.unmodifiableList(this.list);

        protected Entry() {
        }
    }
}

